'use strict';

const permissionsList = [
  "access.admin",
  "access.admin.dashboard",
  "access.admin.profit",
  "access.affiliate",
  "access.affiliate.condition",
  "access.affiliate.referral",
  "access.affiliate.reward",
  "access.ai.investment",
  "access.ai.investment.duration",
  "access.ai.investment.plan",
  "access.announcement",
  "access.api.key",
  "access.binary.duration",
  "access.binary.market",
  "access.binary.order",
  "access.blog",
  "access.blog.author",
  "access.blog.category",
  "access.blog.comment",
  "access.blog.post",
  "access.blog.tag",
  "access.content.media",
  "access.database",
  "access.deposit",
  "access.deposit.gateway",
  "access.deposit.method",
  "access.ecommerce.category",
  "access.ecommerce.dashboard",
  "access.ecommerce.discount",
  "access.ecommerce.order",
  "access.ecommerce.product",
  "access.ecommerce.review",
  "access.ecommerce.shipping",
  "access.ecommerce.wishlist",
  "access.ecosystem",
  "access.ecosystem.custodial.wallet",
  "access.ecosystem.market",
  "access.ecosystem.master.wallet",
  "access.ecosystem.order",
  "access.ecosystem.private.ledger",
  "access.ecosystem.token",
  "access.ecosystem.utxo",
  "access.exchange",
  "access.exchange.market",
  "access.exchange.order",
  "access.faq",
  "access.fiat.currency",
  "access.forex",
  "access.forex.account",
  "access.forex.deposit",
  "access.forex.duration",
  "access.forex.investment",
  "access.forex.plan",
  "access.forex.signal",
  "access.forex.withdraw",
  "access.futures.market",
  "access.futures.order",
  "access.futures.position",
  "access.ico.offer",
  "access.ico.stat",
  "access.ico.transaction",
  "access.investment",
  "access.investment.duration",
  "access.investment.plan",
  "access.mailwizard.campaign",
  "access.mailwizard.template",
  "access.notification.template",
  "access.p2p",
  "access.p2p.dispute",
  "access.p2p.offer",
  "access.p2p.trade",
  "access.permission",
  "access.role",
  "access.slider",
  "access.spot.currency",
  "access.staking",
  "access.staking.pool",
  "access.staking.position",
  "access.support.ticket",
  "access.system.announcement",
  "access.system.log",
  "access.transaction",
  "access.transfer",
  "access.user",
  "access.wallet",
  "access.withdraw",
  "access.withdraw.method",
  "create.admin.profit",
  "create.affiliate.condition",
  "create.affiliate.referral",
  "create.affiliate.reward",
  "create.ai.investment",
  "create.ai.investment.duration",
  "create.ai.investment.plan",
  "create.announcement",
  "create.api.key",
  "create.binary.duration",
  "create.binary.market",
  "create.binary.order",
  "create.blog.author",
  "create.blog.category",
  "create.blog.comment",
  "create.blog.post",
  "create.blog.tag",
  "create.content.media",
  "create.deposit",
  "create.deposit.gateway",
  "create.deposit.method",
  "create.ecommerce.category",
  "create.ecommerce.discount",
  "create.ecommerce.order",
  "create.ecommerce.product",
  "create.ecommerce.review",
  "create.ecommerce.shipping",
  "create.ecommerce.wishlist",
  "create.ecosystem.custodial.wallet",
  "create.ecosystem.market",
  "create.ecosystem.master.wallet",
  "create.ecosystem.order",
  "create.ecosystem.private.ledger",
  "create.ecosystem.token",
  "create.ecosystem.utxo",
  "create.exchange",
  "create.exchange.market",
  "create.exchange.order",
  "create.faq",
  "create.faq.feedback",
  "create.fiat.currency",
  "create.forex.account",
  "create.forex.deposit",
  "create.forex.duration",
  "create.forex.investment",
  "create.forex.plan",
  "create.forex.signal",
  "create.forex.withdraw",
  "create.futures.market",
  "create.futures.order",
  "create.futures.position",
  "create.ico.offer",
  "create.ico.transaction",
  "create.investment",
  "create.investment.duration",
  "create.investment.plan",
  "create.kyc.level",
  "create.license",
  "create.mailwizard.campaign",
  "create.mailwizard.template",
  "create.notification.template",
  "create.p2p.dispute",
  "create.p2p.offer",
  "create.p2p.trade",
  "create.page",
  "create.payment.intent",
  "create.permission",
  "create.role",
  "create.slider",
  "create.spot.currency",
  "create.staking.earning",
  "create.staking.performance",
  "create.staking.pool",
  "create.staking.position",
  "create.support.ticket",
  "create.system.announcement",
  "create.system.log",
  "create.transaction",
  "create.transfer",
  "create.user",
  "import.user",
  "export.user",
  "create.wallet",
  "create.withdraw",
  "create.withdraw.method",
  "delete.admin.profit",
  "delete.affiliate.condition",
  "delete.affiliate.referral",
  "delete.affiliate.reward",
  "delete.ai.investment",
  "delete.ai.investment.duration",
  "delete.ai.investment.plan",
  "delete.announcement",
  "delete.api.key",
  "delete.binary.duration",
  "delete.binary.market",
  "delete.binary.order",
  "delete.blog.author",
  "delete.blog.category",
  "delete.blog.comment",
  "delete.blog.post",
  "delete.blog.tag",
  "delete.content.media",
  "delete.deposit",
  "delete.deposit.gateway",
  "delete.deposit.method",
  "delete.ecommerce.category",
  "delete.ecommerce.discount",
  "delete.ecommerce.order",
  "delete.ecommerce.product",
  "delete.ecommerce.review",
  "delete.ecommerce.shipping",
  "delete.ecommerce.wishlist",
  "delete.ecosystem.custodial.wallet",
  "delete.ecosystem.market",
  "delete.ecosystem.master.wallet",
  "delete.ecosystem.order",
  "delete.ecosystem.private.ledger",
  "delete.ecosystem.token",
  "delete.ecosystem.utxo",
  "delete.exchange",
  "delete.exchange.market",
  "delete.exchange.order",
  "delete.faq",
  "delete.faq.feedback",
  "delete.fiat.currency",
  "delete.forex.account",
  "delete.forex.deposit",
  "delete.forex.duration",
  "delete.forex.investment",
  "delete.forex.plan",
  "delete.forex.signal",
  "delete.forex.withdraw",
  "delete.futures.market",
  "delete.futures.order",
  "delete.futures.position",
  "delete.ico.offer",
  "delete.ico.transaction",
  "delete.investment",
  "delete.investment.duration",
  "delete.investment.plan",
  "delete.kyc.application",
  "delete.kyc.level",
  "delete.mailwizard.campaign",
  "delete.mailwizard.template",
  "delete.notification.template",
  "delete.p2p.dispute",
  "delete.p2p.offer",
  "delete.p2p.trade",
  "delete.page",
  "delete.payment.intent",
  "delete.permission",
  "delete.role",
  "delete.slider",
  "delete.spot.currency",
  "delete.staking.pool",
  "delete.staking.position",
  "delete.support.ticket",
  "delete.system.announcement",
  "delete.system.log",
  "delete.transaction",
  "delete.transfer",
  "delete.user",
  "delete.wallet",
  "delete.withdraw",
  "delete.withdraw.method",
  "edit.admin.profit",
  "edit.affiliate.condition",
  "edit.affiliate.referral",
  "edit.affiliate.reward",
  "edit.ai.investment",
  "edit.ai.investment.duration",
  "edit.ai.investment.plan",
  "edit.announcement",
  "edit.api.key",
  "edit.binary.duration",
  "edit.binary.market",
  "edit.binary.order",
  "edit.blog.author",
  "edit.blog.category",
  "edit.blog.comment",
  "edit.blog.post",
  "edit.blog.tag",
  "edit.content.media",
  "edit.deposit",
  "edit.deposit.gateway",
  "edit.deposit.method",
  "edit.ecommerce.category",
  "edit.ecommerce.discount",
  "edit.ecommerce.order",
  "edit.ecommerce.product",
  "edit.ecommerce.review",
  "edit.ecommerce.shipping",
  "edit.ecommerce.wishlist",
  "edit.ecosystem.blockchain",
  "edit.ecosystem.custodial.wallet",
  "edit.ecosystem.market",
  "edit.ecosystem.master.wallet",
  "edit.ecosystem.order",
  "edit.ecosystem.private.ledger",
  "edit.ecosystem.token",
  "edit.ecosystem.utxo",
  "edit.exchange",
  "edit.exchange.market",
  "edit.exchange.order",
  "edit.extension",
  "edit.faq",
  "edit.faq.feedback",
  "edit.faq.question",
  "edit.fiat.currency",
  "edit.forex.account",
  "edit.forex.deposit",
  "edit.forex.duration",
  "edit.forex.investment",
  "edit.forex.plan",
  "edit.forex.signal",
  "edit.forex.withdraw",
  "edit.futures.market",
  "edit.futures.order",
  "edit.futures.position",
  "edit.ico.offer",
  "edit.ico.settings",
  "edit.ico.transaction",
  "edit.investment",
  "edit.investment.duration",
  "edit.investment.plan",
  "edit.kyc.application",
  "edit.kyc.level",
  "edit.kyc.verification",
  "edit.mailwizard.campaign",
  "edit.mailwizard.template",
  "edit.notification.template",
  "edit.p2p.dispute",
  "edit.p2p.offer",
  "edit.p2p.trade",
  "edit.page",
  "edit.payment.intent",
  "edit.permission",
  "edit.role",
  "edit.settings",
  "edit.slider",
  "edit.spot.currency",
  "edit.staking.earning",
  "edit.staking.pool",
  "edit.staking.position",
  "edit.support.ticket",
  "edit.system.announcement",
  "edit.system.log",
  "edit.transaction",
  "edit.transfer",
  "edit.user",
  "edit.wallet",
  "edit.withdraw",
  "edit.withdraw.method",
  "view.admin.profit",
  "view.affiliate.condition",
  "view.affiliate.referral",
  "view.affiliate.reward",
  "view.ai.investment",
  "view.ai.investment.duration",
  "view.ai.investment.plan",
  "view.announcement",
  "view.api.key",
  "view.binary.duration",
  "view.binary.market",
  "view.binary.order",
  "view.blog.author",
  "view.blog.category",
  "view.blog.comment",
  "view.blog.post",
  "view.blog.tag",
  "view.content.media",
  "view.crm.role",
  "view.cron",
  "view.deposit",
  "view.deposit.gateway",
  "view.deposit.method",
  "view.ecommerce.category",
  "view.ecommerce.discount",
  "view.ecommerce.order",
  "view.ecommerce.product",
  "view.ecommerce.review",
  "view.ecommerce.shipping",
  "view.ecommerce.wishlist",
  "view.ecosystem.blockchain",
  "view.ecosystem.custodial.wallet",
  "view.ecosystem.market",
  "view.ecosystem.master.wallet",
  "view.ecosystem.order",
  "view.ecosystem.private.ledger",
  "view.ecosystem.token",
  "view.ecosystem.utxo",
  "view.exchange",
  "view.exchange.balance",
  "view.exchange.fee",
  "view.exchange.market",
  "view.exchange.order",
  "view.exchange.watchlist",
  "view.extension",
  "view.faq",
  "view.faq.category",
  "view.faq.feedback",
  "view.faq.question",
  "view.fiat.currency",
  "view.forex.account",
  "view.forex.deposit",
  "view.forex.duration",
  "view.forex.investment",
  "view.forex.plan",
  "view.forex.signal",
  "view.forex.withdraw",
  "view.futures.market",
  "view.futures.order",
  "view.futures.position",
  "view.ico.offer",
  "view.ico.settings",
  "view.ico.transaction",
  "view.investment",
  "view.investment.duration",
  "view.investment.plan",
  "view.kyc.application",
  "view.kyc.level",
  "view.kyc.verification",
  "view.mailwizard.campaign",
  "view.mailwizard.template",
  "view.notification.template",
  "view.p2p.activity",
  "view.p2p.dispute",
  "view.p2p.offer",
  "view.p2p.trade",
  "view.page",
  "view.payment.intent",
  "view.permission",
  "view.role",
  "view.slider",
  "view.spot.currency",
  "view.staking.activity",
  "view.staking.earning",
  "view.staking.performance",
  "view.staking.pool",
  "view.staking.position",
  "view.support.ticket",
  "view.system.announcement",
  "view.system.log",
  "view.transaction",
  "view.transfer",
  "view.user",
  "view.wallet",
  "view.withdraw",
  "view.withdraw.method",
  "access.nft",
  "access.nft.category",
  "access.nft.collection",
  "access.nft.token",
  "access.nft.listing",
  "access.nft.auction",
  "access.nft.activity",
  "access.nft.sale",
  "access.nft.analytics",
  "access.nft.settings",
  "access.nft.staking",
  "create.nft.category",
  "create.nft.collection",
  "create.nft.token",
  "create.nft.listing",
  "create.nft.auction",
  "create.nft.activity",
  "create.nft.sale",
  "create.nft.staking",
  "edit.nft.category",
  "edit.nft.collection",
  "edit.nft.token",
  "edit.nft.listing",
  "edit.nft.auction",
  "edit.nft.activity",
  "edit.nft.sale",
  "edit.nft.analytics",
  "edit.nft.settings",
  "edit.nft.staking",
  "delete.nft.category",
  "delete.nft.collection",
  "delete.nft.token",
  "delete.nft.listing",
  "delete.nft.auction",
  "delete.nft.activity",
  "delete.nft.sale",
  "delete.nft.staking",
  "view.nft.category",
  "view.nft.collection",
  "view.nft.token",
  "view.nft.listing",
  "view.nft.auction",
  "view.nft.activity",
  "view.nft.sale",
  "view.nft.analytics",
  "view.nft.settings",
  "view.nft.staking",
];

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    const existingPermissions = await queryInterface.sequelize.query(
      "SELECT name FROM permission",
      { type: queryInterface.sequelize.QueryTypes.SELECT }
    );

    const existingPermissionNames = existingPermissions.map((p) => p.name);

    const newPermissions = permissionsList
      .filter((permission) => !existingPermissionNames.includes(permission))
      .map((permission) => ({
        name: permission,
      }));

    if (newPermissions.length > 0) {
      await queryInterface.bulkInsert("permission", newPermissions);
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete("permission", {
      name: permissionsList,
    });
  },
};
